/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Disease;
import com.minecolonies.coremod.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingWorkerView;
import com.minecolonies.coremod.colony.jobs.JobHealer;
import com.minecolonies.coremod.entity.ai.citizen.healer.Patient;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingHospital
extends AbstractBuildingWorker {
    private static final String HOSPITAL_DESC = "hospital";
    private static final int MAX_BUILDING_LEVEL = 5;
    @NotNull
    private final Map<BlockPos, Integer> bedMap = new HashMap<BlockPos, Integer>();
    private final Map<Integer, Patient> patients = new HashMap<Integer, Patient>();

    public BuildingHospital(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return HOSPITAL_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobHealer(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return "com.minecolonies.coremod.job.healer";
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Mana;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Knowledge;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.hospital;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT bedTagList = compound.func_150295_c("beds", 10);
        for (int i = 0; i < bedTagList.size(); ++i) {
            CompoundNBT bedCompound = bedTagList.func_150305_b(i);
            BlockPos bedPos = BlockPosUtil.read(bedCompound, "pos");
            if (this.bedMap.containsKey(bedPos)) continue;
            this.bedMap.put(bedPos, bedCompound.func_74762_e("id"));
        }
        ListNBT patientTagList = compound.func_150295_c("patients", 10);
        for (int i = 0; i < patientTagList.size(); ++i) {
            CompoundNBT patientCompound = patientTagList.func_150305_b(i);
            int patientId = patientCompound.func_74762_e("id");
            if (this.patients.containsKey(patientId)) continue;
            this.patients.put(patientId, new Patient(patientCompound));
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (!this.bedMap.isEmpty()) {
            ListNBT bedTagList = new ListNBT();
            for (Map.Entry<BlockPos, Integer> entry : this.bedMap.entrySet()) {
                CompoundNBT bedCompound = new CompoundNBT();
                BlockPosUtil.write(bedCompound, "pos", entry.getKey());
                bedCompound.func_74768_a("id", entry.getValue().intValue());
                bedTagList.add((Object)bedCompound);
            }
            compound.func_218657_a("beds", (INBT)bedTagList);
        }
        if (!this.patients.isEmpty()) {
            ListNBT patientTagList = new ListNBT();
            for (Patient patient : this.patients.values()) {
                CompoundNBT patientCompound = new CompoundNBT();
                patient.write(patientCompound);
                patientTagList.add((Object)patientCompound);
            }
            compound.func_218657_a("patients", (INBT)patientTagList);
        }
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(blockState, pos, world);
        BlockPos registrationPosition = pos;
        if (blockState.func_177230_c() instanceof BedBlock) {
            if (blockState.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.FOOT) {
                registrationPosition = registrationPosition.func_177972_a((Direction)blockState.func_177229_b((Property)BedBlock.field_185512_D));
            }
            if (!this.bedMap.containsKey(registrationPosition)) {
                this.bedMap.put(registrationPosition, 0);
            }
        }
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (citizen != null) {
            Optional<AbstractEntityCitizen> optCitizen = citizen.getEntity();
            optCitizen.ifPresent(entityCitizen -> AttributeModifierUtils.removeModifier((LivingEntity)entityCitizen, "SkillSpeedBonus", Attributes.field_233821_d_));
        }
        super.removeCitizen(citizen);
    }

    @NotNull
    public List<BlockPos> getBedList() {
        return ImmutableList.copyOf(this.bedMap.keySet());
    }

    public List<Patient> getPatients() {
        return ImmutableList.copyOf(this.patients.values());
    }

    public void removePatientFile(Patient patient) {
        this.patients.remove(patient.getId());
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> map = super.getRequiredItemsAndAmount();
        map.put(this::doesAnyPatientRequireStack, (Tuple<Integer, Boolean>)new Tuple((Object)10, (Object)false));
        return map;
    }

    private boolean doesAnyPatientRequireStack(ItemStack stack) {
        for (Patient patient : this.patients.values()) {
            String diseaseName;
            ICitizenData data = this.colony.getCitizenManager().getCivilian(patient.getId());
            if (data == null || !data.getEntity().isPresent() || !data.getEntity().get().getCitizenDiseaseHandler().isSick() || (diseaseName = data.getEntity().get().getCitizenDiseaseHandler().getDisease()).isEmpty()) continue;
            Disease disease = IColonyManager.getInstance().getCompatibilityManager().getDisease(diseaseName);
            for (ItemStack cure : disease.getCure()) {
                if (!cure.func_77969_a(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public void checkOrCreatePatientFile(int citizenId) {
        if (!this.patients.containsKey(citizenId)) {
            this.patients.put(citizenId, new Patient(citizenId));
        }
    }

    public void registerPatient(BlockPos bedPos, int citizenId) {
        this.bedMap.put(bedPos, citizenId);
        this.setBedOccupation(bedPos, citizenId != 0);
    }

    private void setBedOccupation(BlockPos bedPos, boolean occupied) {
        BlockState state = this.colony.getWorld().func_180495_p(bedPos);
        if (state.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F)) {
            this.colony.getWorld().func_180501_a(bedPos, (BlockState)state.func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(occupied)), 3);
            BlockPos feetPos = bedPos.func_177972_a(((Direction)state.func_177229_b((Property)BedBlock.field_185512_D)).func_176734_d());
            BlockState feetState = this.colony.getWorld().func_180495_p(feetPos);
            if (feetState.func_177230_c().func_203417_a((ITag)BlockTags.field_219747_F)) {
                this.colony.getWorld().func_180501_a(feetPos, (BlockState)feetState.func_206870_a((Property)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(occupied)), 3);
            }
        }
    }

    @Override
    public void onWakeUp() {
        for (Map.Entry<BlockPos, Integer> entry : new ArrayList<Map.Entry<BlockPos, Integer>>(this.bedMap.entrySet())) {
            BlockState state = this.colony.getWorld().func_180495_p(entry.getKey());
            if (state.func_177230_c() instanceof BedBlock) {
                if (entry.getValue() == 0 && ((Boolean)state.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue()) {
                    this.setBedOccupation(entry.getKey(), false);
                    continue;
                }
                if (entry.getValue() == 0) continue;
                ICitizenData citizen = this.colony.getCitizenManager().getCivilian(entry.getValue());
                if (citizen != null) {
                    if (((Boolean)state.func_177229_b((Property)BedBlock.field_176471_b)).booleanValue()) {
                        if (citizen.isAsleep() && citizen.getEntity().isPresent() && !(citizen.getEntity().get().func_233580_cy_().func_177951_i((Vector3i)entry.getKey()) > 2.0)) continue;
                        this.setBedOccupation(entry.getKey(), false);
                        this.bedMap.put(entry.getKey(), 0);
                        continue;
                    }
                    if (!citizen.isAsleep() || !citizen.getEntity().isPresent() || !(citizen.getEntity().get().func_233580_cy_().func_177951_i((Vector3i)entry.getKey()) < 2.0)) continue;
                    this.setBedOccupation(entry.getKey(), true);
                    continue;
                }
                this.bedMap.put(entry.getKey(), 0);
                continue;
            }
            this.bedMap.remove(entry.getKey());
        }
    }

    @Override
    public boolean canEat(ItemStack stack) {
        for (Disease disease : IColonyManager.getInstance().getCompatibilityManager().getDiseases()) {
            for (ItemStack cure : disease.getCure()) {
                if (!cure.func_77969_a(stack)) continue;
                return false;
            }
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingWorkerView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerModulePlaceholder<View>(this, BuildingHospital.HOSPITAL_DESC);
        }
    }
}

